<?xml version="1.0"?>
<instrumentationManifest xsi:schemaLocation="http://schemas.microsoft.com/win/2004/08/events eventman.xsd" xmlns="http://schemas.microsoft.com/win/2004/08/events" xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:trace="http://schemas.microsoft.com/win/2004/08/events/trace">
	<instrumentation>
		<counters schemaVersion="1.1" xmlns="http://schemas.microsoft.com/win/2005/12/counters">
			<provider providerName="Mlx5Provider" providerGuid="{16831217-C60E-4255-87B3-3AF46BD095C0}" applicationIdentity="Mlx5.sys" providerType="kernelMode" callback="custom">
				<counterSet name="Mellanox WinOF-2 Port Traffic" symbol="TrafficCounters" guid="{66F34001-AEB6-47ED-97A1-FC6AFE721A19}" uri="Mlx5.TrafficCounters" description="This set contains traffic counters" instances="multipleAggregate">
					<structs>
						<struct name="TrafficCounterStruct" type="traffic_counters"></struct>
					</structs>
					<counter name="Bytes Received" uri="Mlx5.TrafficCounters.Bytes_Received" description="Shows the number of bytes received by network adapter. The counted bytes include framing characters." id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64BytesReceived"></counter>
					<counter name="KBytes Received/Sec" uri="Mlx5.TrafficCounters.KBytes_Received_Sec" description="Shows the rate at which kilobytes are received by network adapter. The counted kilobytes include framing characters." id="2" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64KBytesReceivedSec"></counter>
					<counter name="Packets Received" uri="Mlx5.TrafficCounters.Packets_Received" description="Shows the number of packets received by network interface." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceived"></counter>
					<counter name="Packets Received/Sec" uri="Mlx5.TrafficCounters.Packets_Received_Sec" description="Shows the rate at which packets are received by network interface." id="4" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedSec"></counter>
					<counter name="Bytes Sent" uri="Mlx5.TrafficCounters.Bytes_Sent" description="Shows the number of bytes sent by network adapter. The counted bytes include framing characters." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64BytesSent"></counter>
					<counter name="KBytes Sent/Sec" uri="Mlx5.TrafficCounters.KBytes_Sent_Sec" description="Shows the rate at which kilobytes are sent by network adapter. The counted kilobytes include framing characters." id="6" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64KBytesSentSec"></counter>
					<counter name="Packets Sent" uri="Mlx5.TrafficCounters.Packets_Sent" description="Shows the number of packets sent by network interface." id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsSent"></counter>
					<counter name="Packets Sent/Sec" uri="Mlx5.TrafficCounters.Packets_Sent_Sec" description="Shows the rate at which packets are sent by network interface." id="8" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsSentSec"></counter>
					<counter name="Bytes Total" uri="Mlx5.TrafficCounters.Bytes_Total" description="Shows the total of bytes handled by network adapter. The counted bytes include framing characters." id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64BytesTotal"></counter>
					<counter name="KBytes Total/Sec" uri="Mlx5.TrafficCounters.KBytes_Total_Sec" description="Shows the total rate of kilobytes that are sent and received by network adapter. The counted kilobytes include framing characters." id="10" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64KBytesTotalSec"></counter>
					<counter name="Packets Total" uri="Mlx5.TrafficCounters.Packets_Total" description="Shows the total of packets handled by network interface." id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsTotal"></counter>
					<counter name="Packets Total/Sec" uri="Mlx5.TrafficCounters.Packets_Total_Sec" description="Shows the rate at which packets are sent and received by network interface." id="12" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsTotalSec"></counter>
					<counter name="Control Packets" uri="Mlx5.TrafficCounters.Control_Packets" description="The total number of successfully received control frames." id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64ControlPackets"></counter>
					<counter name="Packets Outbound Errors" uri="Mlx5.TrafficCounters.Packets_Outbound_Errors" description="Shows the number of outbound packets that could not be transmitted because of errors found in the physical layer." id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsOutboundErrors"></counter>
					<counter name="Packets Outbound Discarded" uri="Mlx5.TrafficCounters.Packets_Outbound_Discarded" description="Shows the number of outbound packets to be discarded in the physical layer, even though no errors had been detected to prevent transmission. One possible reason for discarding packets could be to free up buffer space." id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsOutboundDiscarded"></counter>
					<counter name="Packets Received Errors" uri="Mlx5.TrafficCounters.Packets_Received_Errors" description="Shows the number of inbound packets that contained errors in the physical layer, preventing them from being deliverable." id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedErrors"></counter>
					<counter name="Packets Received Frame Length Error" uri="Mlx5.TrafficCounters.Packets_Received_Frame_Length_Error" description="Shows the number of inbound packets that contained error where the frame has length error. Packets received with frame length error are a subset of packets received errors." id="17" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedFrameLengthError"></counter>
					<counter name="Packets Received Symbol Error" uri="Mlx5.TrafficCounters.Packets_Received_Symbol_Error" description="Shows the number of inbound packets that contained symbol error or an invalid block. Packets received with symbol error are a subset of packets received errors." id="18" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedSymbolError"></counter>
					<counter name="Packets Received Bad CRC Error" uri="Mlx5.TrafficCounters.Packets_Received_Bad_CRC_Error" description="Shows the number of inbound packets that contained bad CRC error. Packets received with bad CRC error are a subset of packets received errors." id="19" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedBadCRCError"></counter>
					<counter name="Packets Received Discarded - No Receive WQEs" uri="Mlx5.TrafficCounters.Packets_Received_Discarded_No_Recv_WQEs" description="Packets discarded due to no receive descriptors posted by driver or software." id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64PacketsReceivedDiscardedNoRecvWQEs"></counter>
					<counter name="RSC Aborts" uri="Mlx5.TrafficCounters.Rsc_Aborts" description="Number of RSC abort events. That is, the number of exceptions other than the IP datagram length being exceeded. This includes the cases where a packet is not coalesced because of insufficient hardware resources." id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscAborts"></counter>
					<counter name="RSC Coalesced Events" uri="Mlx5.TrafficCounters.Rsc_Coalesced_Events" description="Number of RSC Coalesced events. That is, the total number of packets that were formed from coalescing packets." id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscCoalescedEvents"></counter>
					<counter name="RSC Coalesced Octets" uri="Mlx5.TrafficCounters.Rsc_Coalesced_Octets" description="Number of RSC Coalesced bytes." id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscCoalescedOctets"></counter>
					<counter name="RSC Coalesced Packets" uri="Mlx5.TrafficCounters.Rsc_Coalesced_Packets" description="Number of RSC Coalesced Packets." id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscCoalescedPackets"></counter>
					<counter name="RSC Average Packet Size" uri="Mlx5.TrafficCounters.RSC_Average_Packet_Size" description="RSC Average Packet Size is the average size in bytes of received packets across all TCP connections." id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="TrafficCounterStruct" field="u64RscAveragePacketSize"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Port QoS" symbol="QoSCounters" guid="{9EFE5F1D-D787-4B49-9D80-8E59D65A30AE}" uri="Mlx5.QoSCounters" description="This set contains QoS counters" instances="multipleAggregate">
					<structs>
						<struct name="QoSCounterStruct" type="QoS_counters"></struct>
					</structs>
					<counter name="Bytes Received" uri="Mlx5.QoSCounters.Bytes_Received" description="The number of bytes received that are covered by this priority. The counted bytes include framing characters." id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64BytesReceived"></counter>
					<counter name="KBytes Received/Sec" uri="Mlx5.QoSCounters.KBytes_Received_Sec" description="The number of kilobytes received per second that are covered by this priority. The counted kilobytes include framing characters." id="2" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64KBytesReceivedSec"></counter>
					<counter name="Packets Received" uri="Mlx5.QoSCounters.Packets_Received" description="The number of packets received that are covered by this priority." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsReceived"></counter>
					<counter name="Packets Received/Sec" uri="Mlx5.QoSCounters.Packets_Received_Sec" description="The number of packets received per second that are covered by this priority." id="4" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsReceivedSec"></counter>
					<counter name="Bytes Sent" uri="Mlx5.QoSCounters.Bytes_Sent" description="The number of bytes sent that are covered by this priority. The counted bytes include framing characters." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64BytesSent"></counter>
					<counter name="KBytes Sent/Sec" uri="Mlx5.QoSCounters.KBytes_Sent_Sec" description="The number of kilobytes sent per second that are covered by this priority. The counted kilobytes include framing characters." id="6" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64KBytesSentSec"></counter>
					<counter name="Packets Sent" uri="Mlx5.QoSCounters.Packets_Sent" description="The number of packets sent that are covered by this priority." id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsSent"></counter>
					<counter name="Packets Sent/Sec" uri="Mlx5.QoSCounters.Packets_Sent_Sec" description="The number of packets sent per second that are covered by this priority." id="8" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsSentSec"></counter>
					<counter name="Bytes Total" uri="Mlx5.QoSCounters.Bytes_Total" description="The total number of bytes that are covered by this priority. The counted bytes include framing characters." id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64BytesTotal"></counter>
					<counter name="KBytes Total/Sec" uri="Mlx5.QoSCounters.KBytes_Total_Sec" description="The total number of kilobytes per second that are covered by this priority. The counted kilobytes include framing characters." id="10" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64KBytesTotalSec"></counter>
					<counter name="Packets Total" uri="Mlx5.QoSCounters.Packets_Total" description="The total number of packets that are covered by this priority." id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsTotal"></counter>
					<counter name="Packets Total/Sec" uri="Mlx5.QoSCounters.Packets_Total_Sec" description="The total number of packets per second that are covered by this priority." id="12" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64PacketsTotalSec"></counter>
					<counter name="Sent Pause Frames" uri="Mlx5.QoSCounters.Sent_Pause_Frames" description="The number of pause frames that were sent to this priority. The untagged instance indicates global pause frames that were sent." id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64SentPauseFrames"></counter>
					<counter name="Sent Pause Duration" uri="Mlx5.QoSCounters.Sent_Pause_Duration" description="The total duration in microseconds that transmission of packets has been paused on this priority." id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64SentPauseDuration"></counter>
					<counter name="Rcv Pause Frames" uri="Mlx5.QoSCounters.Rcv_Pause_Frames" description="The number of pause frames that were received for this priority. The untagged instance indicates global pause frames that were received." id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64RcvPauseFrames"></counter>
					<counter name="Rcv Pause Duration" uri="Mlx5.QoSCounters.Rcv_Pause_Duration" description="The total duration in microseconds of pause that was requested by the other end to freeze transmission on this priority." id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="QoSCounterStruct" field="u64RcvPauseDuration"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 VF Port Traffic" symbol="VPortTrafficCounters" guid="{f6375299-ed2e-4abb-ad01-3f658f29ea27}" uri="Mlx5.VPortTrafficCounters" description="This set contains VPort traffic counters" instances="multipleAggregate">
					<structs>
						<struct name="VPortTrafficCounterStruct" type="NDIS_STATISTICS_INFO"></struct>
					</structs>
					<counter name="Bytes Received/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Received_Sec" description="Shows the rate at which bytes are received over each network VPort. The counted bytes include framing characters." id="1" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInOctets"></counter>
					<counter name="Bytes Sent/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Sent_Sec" description="Shows the rate at which bytes are sent over each network VPort. The counted bytes include framing characters." id="2" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutOctets"></counter>
					<counter name="Packets Outbound Discarded" uri="Mlx5.VPortTrafficCounters.Packets_Outbound_Discarded" description="Shows the number of outbound packets to be discarded even though no errors had been detected to prevent transmission. One possible reason for discarding a packet could be to free up buffer space." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifOutDiscards"></counter>
					<counter name="Packets Outbound Errors" uri="Mlx5.VPortTrafficCounters.Packets_Outbound_Errors" description="Shows the number of outbound packets that could not be transmitted because of errors." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifOutErrors"></counter>
					<counter name="Packets Received Discarded" uri="Mlx5.VPortTrafficCounters.Packets_Received_Discarded" description="Shows the number of inbound packets that were chosen to be discarded even though no errors had been detected to prevent their being deliverable to a higher-layer protocol. One possible reason for discarding such a packet could be to free up buffer space." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifInDiscards"></counter>
					<counter name="Packets Received Errors" uri="Mlx5.VPortTrafficCounters.Packets_Received_Errors" description="Shows the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol." id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifInErrors"></counter>
					<counter name="Packets Received Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Received_Unicast_Sec" description="Shows the rate at which subnet-unicast packets are delivered to a higher-layer protocol." id="7" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInUcastPkts"></counter>
					<counter name="Packets Received Broadcast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Received_Broadcast_Sec" description="Shows the rate at which subnet-broadcast packets are delivered to a higher-layer protocol." id="8" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInBroadcastPkts"></counter>
					<counter name="Packets Received Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Received_Multicast_Sec" description="Shows the rate at which subnet-multicast packets are delivered to a higher-layer protocol." id="9" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInMulticastPkts"></counter>
					<counter name="Packets Sent Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Sent_Unicast_Sec" description="Shows the rate at which packets are requested to be transmitted to subnet-unicast addresses by higher-level protocols. The rate includes the packets that were discarded or not sent." id="10" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutUcastPkts"></counter>
					<counter name="Packets Sent Broadcast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Sent_Broadcast_Sec" description="Shows the rate at which packets are requested to be transmitted to subnet-broadcast addresses by higher-level protocols. The rate includes the packets that were discarded or not sent." id="11" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutBroadcastPkts"></counter>
					<counter name="Packets Sent Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Packets_Sent_Multicast_Sec" description="Shows the rate at which packets are requested to be transmitted to subnet-multicast addresses by higher-level protocols. The rate includes the packets that were discarded or not sent." id="12" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutMulticastPkts"></counter>
					<counter name="Bytes Received Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Received_Unicast_Sec" description="Shows the rate at which subnet-unicast bytes are delivered to a higher-layer protocol." id="13" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInUcastOctets"></counter>
					<counter name="Bytes Received Broadcast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Received_Broadcast_Sec" description="Shows the rate at which subnet-broadcast bytes are delivered to a higher-layer protocol." id="14" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInBroadcastOctets"></counter>
					<counter name="Bytes Received Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Received_Multicast_Sec" description="Shows the rate at which subnet-multicast bytes are delivered to a higher-layer protocol." id="15" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCInMulticastOctets"></counter>
					<counter name="Bytes Sent Unicast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Sent_Unicast_Sec" description="Shows the rate at which bytes are requested to be transmitted to subnet-unicast addresses by higher-level protocols. The rate includes the bytes that were discarded or not sent." id="16" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutUcastOctets"></counter>
					<counter name="Bytes Sent Broadcast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Sent_Broadcast_Sec" description="Shows the rate at which bytes are requested to be transmitted to subnet-broadcast addresses by higher-level protocols. The rate includes the bytes that were discarded or not sent." id="17" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutBroadcastOctets"></counter>
					<counter name="Bytes Sent Multicast/Sec" uri="Mlx5.VPortTrafficCounters.Bytes_Sent_Multicast_Sec" description="Shows the rate at which bytes are requested to be transmitted to subnet-multicast addresses by higher-level protocols. The rate includes the bytes that were discarded or not sent." id="18" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="VPortTrafficCounterStruct" field="ifHCOutMulticastOctets"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Congestion Control" symbol="CongestionControlCounters" guid="{255816e0-14ec-46cd-89ea-471e09d5da4d}" uri="Mlx5.CongestionControlCounters" description="This set contains congestion control counters" instances="multipleAggregate">
					<structs>
						<struct name="CongestionControlCounterStruct" type="CongCtrlCounters"></struct>
					</structs>
					<counter name="Reaction Point - Current Number of Flows" uri="Mlx5.CongestionControlCounters.Reaction_Point_Current_Number_of_Flows" description="Current Number of Rate Limited Flows due to RoCEv2 Congestion Management." id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="uReactionPointCurrentNumberOfFlows"></counter>
					<counter name="Reaction Point - Ignored CNP Packets" uri="Mlx5.CongestionControlCounters.Reaction_Point_Ignored_CNP_Packets" description="The number of ignored rate limitation requests." id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="u64ReactionPointIgnoredCNPPackets"></counter>
					<counter name="Reaction Point - Successfully Handled CNP Packets" uri="Mlx5.CongestionControlCounters.Reaction_Point_Successfully_Handled_CNP_Packets" description="The number of congestion notification packet (CNP) received and handled successfully." id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="u64ReactionPointSuccessfullyHandledCNPPackets"></counter>
					<counter name="Notification Point - RoCEv2 ECN Marked Packets" uri="Mlx5.CongestionControlCounters.Notification_Point_RoCEv2_ECN_Marked_Packets" description="Number of RoCEv2 packets that were marked as congestion encountered." id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="u64NotificationPointRoCEv2ECNMarkedPackets"></counter>
					<counter name="Notification Point - CNPs Sent Successfully" uri="Mlx5.CongestionControlCounters.Notification_Point_CNPs_Sent_Successfully" description="The number of congestion notification packets (CNPs) successfully sent by the notification point." id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="CongestionControlCounterStruct" field="u64NotificationPointCNPsSentSuccessfully"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Diagnostics" symbol="DiagnosticCounters" guid="{4107e19c-2428-461a-beb6-f5c4d619a260}" uri="Mlx5.DiagnosticCounters" description="This set contains diagnostics counters" instances="multipleAggregate">
					<structs>
						<struct name="DiagnosticCounterStruct" type="DiagCounters"></struct>
					</structs>
					<counter name="Reset Requests" uri="Mlx5.DiagnosticCounters.Reset_Requests" description="Number of resets requested by NDIS" id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ResetRequests"></counter>
					<counter name="Link State Change Events" uri="Mlx5.DiagnosticCounters.Link_State_Change_Events" description="Number of link status updates received from HW" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64LinkStateChangeEvents"></counter>
					<counter name="Queued Send Packets" uri="Mlx5.DiagnosticCounters.Queued_Send_Packets" description="Number of send packets pending transmission due to HW queues overflow" id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64QueuedSendPackets"></counter>
					<counter name="Send Completions in Passive/Sec" uri="Mlx5.DiagnosticCounters.Send_Completions_In_Passive_Sec" description="Number of send completion events handled in passive mode per second" id="4" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64SendCompletionsInPassiveSec"></counter>
					<counter name="Receive Completions in Passive/Sec" uri="Mlx5.DiagnosticCounters.Receive_Completions_In_Passive_Sec" description="Number of receive completion events handled in passive mode per second" id="5" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReceiveCompletionsInPassiveSec"></counter>
					<counter name="Copied Send Packets" uri="Mlx5.DiagnosticCounters.Copied_Send_Packets" description="Number of send packets that were copied in slow path" id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CopiedSendPackets"></counter>
					<counter name="Correct Checksum Packets In Slow Path" uri="Mlx5.DiagnosticCounters.Correct_Checksum_Packets_In_Slow_Path" description="Number of receive packets that required manual checksum calculation that resulted in success" id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CorrectChecksumPacketsInSlowPath"></counter>
					<counter name="Bad Checksum Packets In Slow Path" uri="Mlx5.DiagnosticCounters.Bad_Checksum_Packets_In_Slow_Path" description="Number of receive packets that required manual checksum calculation that resulted in failure" id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64BadChecksumPacketsInSlowPath"></counter>
					<counter name="Undetermined Checksum Packets In Slow Path" uri="Mlx5.DiagnosticCounters.Undetermined_Checksum_Packets_In_Slow_Path" description="Number of receive packets with undetermined checksum result" id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64UndeterminedChecksumPacketsInSlowPath"></counter>
					<counter name="Link State Change Down Events" uri="Mlx5.DiagnosticCounters.Link_State_Change_Down_Events" description="Number of events, received from HW, where the link state changed to down" id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="uPhyLinkDownEvents"></counter>
					<counter name="Watch Dog Expired/Sec" uri="Mlx5.DiagnosticCounters.WatchDogExpired" description="DPC watchdog expirations per second" id="11" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64WatchDogExpired"></counter>
					<counter name="Minor Stall Watermark Reached" uri="Mlx5.DiagnosticCounters.Minor_Stall_Watermark_Reached" description="The number of times the device detected a stalled state for a period longer than device_stall_minor_watermark" id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64MinorStallWatermarkReached"></counter>
					<counter name="Critical Stall Watermark Reached" uri="Mlx5.DiagnosticCounters.Critical_Stall_Watermark_Reached" description="The number of times the port detected a stalled state for a period longer than device_stall_critical_watermark" id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CriticalStallWatermarkReached"></counter>
					<counter name="Head of Queue timeout Packet discarded" uri="Mlx5.DiagnosticCounters.Head_of_Queue_timeout_Packet_discarded" description="Number of packets discarded by the transmitter due to Head-Of-Queue Lifetime Limit timeout" id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64PacketDisDueHoqTimeOut"></counter>
					<counter name="Stalled State Packet discarded" uri="Mlx5.DiagnosticCounters.Stalled_state_Packet_discarded" description="Number of packets discarded by the transmitter due to TC in Stalled state" id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64PacketDisDueTCStalledState"></counter>
					<counter name="Requester Timeout Received" uri="Mlx5.DiagnosticCounters.Requester_time_out_received" description="Number of time out received when the local machine generates" id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RequesterTimeOutReceived"></counter>
					<counter name="Requester Out of Order Sequence NAK" uri="Mlx5.DiagnosticCounters.Requester_out_of_order_sequence_NAK" description="Number of Out of Sequence NAK received when the local machine generates outbound traffic, i.e. the number of times the local machine received NAKs indicating OOS on the receiving side" id="17" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RequesterOOOSeqNAKReceived"></counter>
					<counter name="Requester RNR NAK" uri="Mlx5.DiagnosticCounters.Requester_RNR_NAK" description="Number of RNR (Receiver Not Ready) NAKs received when the local machine generates outbound traffic" id="18" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RequesterRNRNAK"></counter>
					<counter name="Responder RNR NAK" uri="Mlx5.DiagnosticCounters.Responder_RNR_NAK" description="Number of RNR (Receiver Not Ready) NAKs sent when the local machine receives inbound traffic" id="19" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ResponderRNRNAK"></counter>
					<counter name="Responder Out of Order Sequence Received" uri="Mlx5.DiagnosticCounters.Responder_out_of_order_sequence_received" description="Number of Out of Sequence packet received when the local machine receives inbound traffic, i.e. the number of times the local machine received messages that are not consecutive" id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ResponderOOOSeqReceived"></counter>
					<counter name="Responder Duplicate Request Received" uri="Mlx5.DiagnosticCounters.Responder_duplicate_request_received" description="Number of duplicate requests received when the local machine receives inbound traffic" id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ResponderDuplicateRequestRecv"></counter>
					<counter name="Requester RNR NAK Retries Exceeded Error" uri="Mlx5.DiagnosticCounters.Requester_RNR_NAK_retries_exceeded_errors" description="Number of RNR (Receiver Not Ready) NAKs retries exceeded errors when the local machine generates outbound traffic" id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RequesterRNRNAKRetriesExceededErr"></counter>
					<counter name="NIC Steering Discards" uri="Mlx5.DiagnosticCounters.NIC_steering_discards" description="Number of packets discarded by steering rules at NIC level, typically due to destination MAC or VLAN mismatch" id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64NicSteeringDiscards"></counter>
					<counter name="Responder Local Length Errors" uri="Mlx5.DiagnosticCounters.Responder_local_length_errors" description="Number of times responder detected local length errors" id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespLocalLengthErr"></counter>
					<counter name="Requester Local Length Errors" uri="Mlx5.DiagnosticCounters.Requester_local_length_errors" description="Number of times requester detected local length errors" id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqLocalLengthErr"></counter>
					<counter name="Responder Local QP Operation Errors" uri="Mlx5.DiagnosticCounters.Requester_local_qp_errors" description="Number of times responder detected local QP operation errors" id="26" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespLocalQpErr"></counter>
					<counter name="Local Operation Errors" uri="Mlx5.DiagnosticCounters.Local_operation_errors" description="Number of local operation errors" id="27" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64LocalOperationErr"></counter>
					<counter name="Responder Local Protection Errors" uri="Mlx5.DiagnosticCounters.Responder_local_protection_errors" description="Number of times responder detected memory protection error in its local memory subsystem" id="28" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespLocalProtection"></counter>
					<counter name="Requester Local Protection Errors" uri="Mlx5.DiagnosticCounters.Requester_local_protection_errors" description="Number of times requester detected memory protection error in its local memory subsystem" id="29" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqLocalProtection"></counter>
					<counter name="Responder CQEs with Error" uri="Mlx5.DiagnosticCounters.Responder_cqe_error" description="Number of times responder flow reported a completion with error" id="30" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespCqeErr"></counter>
					<counter name="Requester CQEs with Error" uri="Mlx5.DiagnosticCounters.Requester_cqe_error" description="Number of times requester flow reported a completion with error" id="31" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqCqeErr"></counter>
					<counter name="Requester Memory Window Binding Errors" uri="Mlx5.DiagnosticCounters.Requester_mem_win_bind_error" description="Number of times requester detected memory window binding error" id="32" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqMemWinBindErr"></counter>
					<counter name="Requester Bad Response" uri="Mlx5.DiagnosticCounters.Requester_bad_response" description="Number of times an unexpected transport layer opcode was returned by the responder" id="33" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqBadResponse"></counter>
					<counter name="Requester Remote Invalid Request Errors" uri="Mlx5.DiagnosticCounters.Requester_remote_invalid_request" description="Number of times requester detected remote invalid request error" id="34" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqRemoteInvalidReq"></counter>
					<counter name="Responder Remote Invalid Request Errors" uri="Mlx5.DiagnosticCounters.Responder_remote_invalid_request" description="Number of times responder detected remote invalid request error" id="35" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespRemoteInvalidReq"></counter>
					<counter name="Requester Remote Access Errors" uri="Mlx5.DiagnosticCounters.Requester_remote_access_errors" description="Number of times requester detected remote access error" id="36" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqRemoteAccessErr"></counter>
					<counter name="Responder Remote Access Errors" uri="Mlx5.DiagnosticCounters.Responder_remote_access_errors" description="Number of times responder detected remote access error" id="37" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespRemoteAccessErr"></counter>
					<counter name="Requester Remote Operation Errors" uri="Mlx5.DiagnosticCounters.Requester_operation_errors" description="Number of times requester detected remote operation error." id="38" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqRemoteOpErr"></counter>
					<counter name="Requester Retry Exceeded Errors" uri="Mlx5.DiagnosticCounters.Requester_retry_exceeded_errors" description="Number of times requester detected transport retries exceed error" id="39" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqTransportRetriesExceeded"></counter>
					<counter name="Received RDMA Write requests" uri="Mlx5.DiagnosticCounters.ReceivedRDMAWriteRequests" description="Number of RDMA write requests received" id="41" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RxWriteRequests"></counter>
					<counter name="Received RDMA Read requests" uri="Mlx5.DiagnosticCounters.ReceivedRDMAReadRequests" description="Number of RDMA read requests received" id="42" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RxReadRequests"></counter>
					<counter name="Implied NAK Sequence Errors" uri="Mlx5.DiagnosticCounters.ImpliedNAKSequenceErrors" description="Number of times the Requester detected an ACK with a PSN larger than the expected PSN for an RDMA READ or ATOMIC response. The QP retry limit was not exceeded" id="43" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ImpliedNakReceived"></counter>
					<counter name="CQ Overflow" uri="Mlx5.DiagnosticCounters.CqOverflow" description="Number of times a CQ attached to a Queue Pair reached overflow state" id="44" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CqOverflow"></counter>
					<counter name="Responder CQEs flushed with error" uri="Mlx5.DiagnosticCounters.RespCqeFlushError" description="Number of responder CQEs flushed with error flowing queue transition to error state" id="45" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64RespCqeFlushError"></counter>
					<counter name="Requester CQEs flushed with error" uri="Mlx5.DiagnosticCounters.ReqCqeFlushError" description="Number of requester CQEs flushed with error flowing queue transition to error state" id="46" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64ReqCqeFlushError"></counter>
					<counter name="Send queues priority" uri="Mlx5.DiagnosticCounters.SendQueuePriority" description="The total number of queues that are handled by the processor due to async error (e.g. retry exceeded) or due to errored cmd (e.g. 2eer_qp cmd)" id="47" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64SendQueuePriority"></counter>
					<counter name="Current queues under processor handle" uri="Mlx5.DiagnosticCounters.CurrentQUnderProcessorHandle" description="The current number of queues that are handled by the processor due to async error (e.g. retry exceeded) or due to errored cmd (e.g. 2eer_qp cmd)" id="48" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64CurrentQUnderProcessorHandle"></counter>
					<counter name="Total queues under processor handle" uri="Mlx5.DiagnosticCounters.TotalQUnderProcessorHandle" description="The total number of queues that are handled by the processor due to async error (e.g. retry exceeded) or due to errored cmd (e.g. 2eer_qp cmd)" id="49" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DiagnosticCounterStruct" field="u64TotalQUnderProcessorHandle"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Device Diagnostics" symbol="DeviceDiagnosticCounters" guid="{684b7170-ece7-4904-bd68-3b8bac822c36}" uri="Mlx5.DeviceDiagnosticCounters" description="This set contains device diagnostic counters" instances="multipleAggregate">
					<structs>
						<struct name="DeviceDiagnosticCounterStruct" type="DeviceDiagCounters"></struct>
					</structs>
					<counter name="L0 MTT miss" uri="Mlx5.DeviceDiagnosticCounters.L0_MTT_Miss" description="The number of access to L0 MTT that were missed" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MTT_MISS"></counter>
					<counter name="L0 MTT miss/Sec" uri="Mlx5.DeviceDiagnosticCounters.L0_MTT_Miss_Sec" description="The rate of access to L0 MTT that were missed" id="1" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MTT_MISS_SEC"></counter>
					<counter name="L0 MTT hit" uri="Mlx5.DeviceDiagnosticCounters.L0_MTT_Hit" description="The number of access to L0 MTT that were hit" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MTT_HIT"></counter>
					<counter name="L0 MTT hit/Sec" uri="Mlx5.DeviceDiagnosticCounters.L0_MTT_Hit_Sec" description="The rate of access to L0 MTT that were hit" id="3" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MTT_HIT_SEC"></counter>
					<counter name="L1 MTT miss" uri="Mlx5.DeviceDiagnosticCounters.L1_MTT_Miss" description="The number of access to L1 MTT that were missed" id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MTT_MISS"></counter>
					<counter name="L1 MTT miss/Sec" uri="Mlx5.DeviceDiagnosticCounters.L1_MTT_Miss_Sec" description="The rate of access to L1 MTT that were missed" id="5" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MTT_MISS_SEC"></counter>
					<counter name="L1 MTT hit" uri="Mlx5.DeviceDiagnosticCounters.L1_MTT_hit" description="The number of access to L1 MTT that were hit" id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MTT_HIT"></counter>
					<counter name="L1 MTT hit/Sec" uri="Mlx5.DeviceDiagnosticCounters.L1_MTT_hit_Sec" description="The rate of access to L1 MTT that were hit" id="7" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MTT_HIT_SEC"></counter>
					<counter name="L0 MPT miss" uri="Mlx5.DeviceDiagnosticCounters.L0_MPT_miss" description="The number of access to L0 MKey that were missed" id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MPT_MISS"></counter>
					<counter name="L0 MPT miss/Sec" uri="Mlx5.DeviceDiagnosticCounters.L0_MPT_miss_Sec" description="The rate of access to L0 MKey that were missed" id="9" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MPT_MISS_SEC"></counter>
					<counter name="L0 MPT hit" uri="Mlx5.DeviceDiagnosticCounters.L0_MPT_hit" description="The number of access to L0 MKey that were hit" id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MPT_HIT"></counter>
					<counter name="L0 MPT hit/Sec" uri="Mlx5.DeviceDiagnosticCounters.L0_MPT_hit_Sec" description="The rate of access to L0 MKey that were hit" id="11" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L0_MPT_HIT_SEC"></counter>
					<counter name="L1 MPT miss" uri="Mlx5.DeviceDiagnosticCounters.L1_MPT_miss" description="The number of access to L1 MKey that were missed" id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MPT_MISS"></counter>
					<counter name="L1 MPT miss/Sec" uri="Mlx5.DeviceDiagnosticCounters.L1_MPT_miss_Sec" description="The rate of access to L1 MKey that were missed" id="13" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MPT_MISS_SEC"></counter>
					<counter name="L1 MPT hit" uri="Mlx5.DeviceDiagnosticCounters.L1_MPT_hit" description="The number of access to L1 MKey that were hit" id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MPT_HIT"></counter>
					<counter name="L1 MPT hit/Sec" uri="Mlx5.DeviceDiagnosticCounters.L1_MPT_hit_Sec" description="The rate of access to L1 MKey that were hit" id="15" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_L1_MPT_HIT_SEC"></counter>
					<counter name="RXS no slow path credis" uri="Mlx5.DeviceDiagnosticCounters.RXS_no_slow_path_credis" description="No room in RXS for slow path packets" id="16" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXB_NO_SLOW_PATH_CREDITS"></counter>
					<counter name="RXS no fast path credis" uri="Mlx5.DeviceDiagnosticCounters.RXS_no_fast_path_credis" description="No room in RXS for fast path packets" id="17" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXB_NO_FAST_PATH_CREDITS"></counter>
					<counter name="RXT no slow path credis" uri="Mlx5.DeviceDiagnosticCounters.RXT_no_slow_path_credis" description="No room in RXT for slow path packets" id="18" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXB_RXT_NO_SLOW_PATH_CRED_PERF_COUNT"></counter>
					<counter name="RXT no fast path credis" uri="Mlx5.DeviceDiagnosticCounters.RXT_no_fast_path_credis" description="No room in RXT for fast path packets" id="19" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXB_RXT_NO_FAST_PATH_CRED_PERF_COUNT"></counter>
					<counter name="Slow path packets slice load" uri="Mlx5.DeviceDiagnosticCounters.Slow_path_packets_slice_load" description="Number of slow path packets loaded to HCA as slices from the network" id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXT_CTRL_PERF_SLICE_LOAD_SLOW"></counter>
					<counter name="Fast path packets slice load" uri="Mlx5.DeviceDiagnosticCounters.Fast_path_packets_slice_load" description="Number of fast path packets loaded to HCA as slices from the network" id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXT_CTRL_PERF_SLICE_LOAD_FAST"></counter>
					<counter name="Steering pipe 0 processing time" uri="Mlx5.DeviceDiagnosticCounters.Steering_pipe_0_processing_time" description="Number of clocks that steering pipe 0 worked" id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXT_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE"></counter>
					<counter name="Steering pipe 1 processing time" uri="Mlx5.DeviceDiagnosticCounters.Steering_pipe_1_processing_time" description="Number of clocks that steering pipe 1 worked" id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXT_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE"></counter>
					<counter name="WQE address translation back-pressure" uri="Mlx5.DeviceDiagnosticCounters.WQE_address_translation_back_pressure" description="No credits between RXW and TPT" id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_PERF_COUNT_TPT_CREDIT"></counter>
					<counter name="Receive WQE cache miss" uri="Mlx5.DeviceDiagnosticCounters.Receive_WQE_cache_miss" description="Number of packets that got miss in RWqe buffer L0 cache" id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_PERF_WB_MISS"></counter>
					<counter name="Receive WQE cache hit" uri="Mlx5.DeviceDiagnosticCounters.Receive_WQE_cache_hit" description="Number of packets that got hit in RWqe buffer L0 cache" id="26" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_PERF_WB_HIT"></counter>
					<counter name="Slow packets miss in LDB L1 cache" uri="Mlx5.DeviceDiagnosticCounters.Slow_packets_miss_in_LDB_L1_cache" description="Number of slow packet that got miss in LDB L1 cache" id="27" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_SLOW_MISS_LDB"></counter>
					<counter name="Slow packets hit in LDB L1 cache" uri="Mlx5.DeviceDiagnosticCounters.Slow_packets_hit_in_LDB_L1_cache" description="Number of slow packet that got hit in LDB L1 cache" id="28" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_SLOW_HIT_LDB"></counter>
					<counter name="Fast packets miss in LDB L1 cache" uri="Mlx5.DeviceDiagnosticCounters.Fast_packets_miss_in_LDB_L1_cache" description="Number of fast packet that got miss in LDB L1 cache" id="29" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_FAST_MISS_LDB"></counter>
					<counter name="Fast packets hit in LDB L1 cache" uri="Mlx5.DeviceDiagnosticCounters.Fast_packets_hit_in_LDB_L1_cache" description="Number of fast packet that got hit in LDB L1 cache" id="30" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_FAST_HIT_LDB"></counter>
					<counter name="Packets miss in LDB L2 cache" uri="Mlx5.DeviceDiagnosticCounters.Packets_miss_in_LDB_L2_cache" description="Number of packet that got miss in LDB L2 cache" id="31" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_L2_CACHE_READ_MISS_LDB"></counter>
					<counter name="Packets hit in LDB L2 cache" uri="Mlx5.DeviceDiagnosticCounters.Packets_hit_in_LDB_L2_cache" description="Number of packet that got hit in LDB L2 cache" id="32" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_L2_CACHE_READ_HIT_LDB"></counter>
					<counter name="Slow packets miss in REQSL L1" uri="Mlx5.DeviceDiagnosticCounters.Slow_packets_miss_in_REQSL_L1" description="Number of slow packet that got miss in REQSL L1 fast cache" id="33" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_SLOW_MISS_REQSL"></counter>
					<counter name="Slow packets hit in REQSL L1" uri="Mlx5.DeviceDiagnosticCounters.Slow_packets_hit_in_REQSL_L1" description="Number of slow packet that got hit in REQSL L1 fast cache" id="34" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_SLOW_HIT_REQSL"></counter>
					<counter name="Fast packets miss in REQSL L1" uri="Mlx5.DeviceDiagnosticCounters.Fast_packets_miss_in_REQSL_L1" description="Number of fast packet that got miss in REQSL L1 fast cache" id="35" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_FAST_MISS_REQSL"></counter>
					<counter name="Fast packets hit in REQSL L1" uri="Mlx5.DeviceDiagnosticCounters.Fast_packets_hit_in_REQSL_L1" description="Number of fast packet that got hit in REQSL L1 fast cache" id="36" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_RX_L1_FAST_HIT_REQSL"></counter>
					<counter name="Packets miss in REQSL L2" uri="Mlx5.DeviceDiagnosticCounters.Packets_miss_in_REQSL_L2" description="Number of packet that got miss in REQSL L2 fast cache" id="37" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_L2_CACHE_READ_MISS_REQSL"></counter>
					<counter name="Packets hit in REQSL L2" uri="Mlx5.DeviceDiagnosticCounters.Packets_hit_in_REQSL_L2" description="Number of packet that got hit in REQSL L2 fast cache" id="38" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXW_PERF_L2_CACHE_READ_HIT_REQSL"></counter>
					<counter name="No PXT credits time" uri="Mlx5.DeviceDiagnosticCounters.No_PXT_credits_time" description="Number of clocks in which there were no PXT credits" id="39" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXS_NO_PXT_CREDITS"></counter>
					<counter name="EQ slices busy time" uri="Mlx5.DeviceDiagnosticCounters.EQ_slices_busy_time" description="Number of clocks where all EQ slices were busy" id="40" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXC_EQ_ALL_SLICES_BUSY"></counter>
					<counter name="CQ slices busy time" uri="Mlx5.DeviceDiagnosticCounters.CQ_slices_busy_time" description="Number of clocks where all CQ slices were busy" id="41" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXC_CQ_ALL_SLICES_BUSY"></counter>
					<counter name="MSIX slices busy time" uri="Mlx5.DeviceDiagnosticCounters.MSIX_slices_busy_time" description="Number of clocks where all MSIX slices were busy" id="42" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_RXC_MSIX_ALL_SLICES_BUSY"></counter>
					<counter name="QP done due to VL limited" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_VL_limited" description="Number of QP done scheduling due to VL limited (e.g. lack of VL credits)" id="43" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_VL_LIMITED"></counter>
					<counter name="QP done due to desched" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_desched" description="Number of QP done scheduling due to desched (Tx full burst size)" id="44" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_DESCHED"></counter>
					<counter name="QP done due to work done" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_work_done" description="Number of QP done scheduling due to work done (Tx all QP data)" id="45" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_WORK_DONE"></counter>
					<counter name="QP done due to limited" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_limited" description="Number of QP done scheduling due to limited (e.g. max read)" id="46" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_LIMITED"></counter>
					<counter name="QP done due to E2E creadits" uri="Mlx5.DeviceDiagnosticCounters.QP_done_due_to_E2E_creadits" description="Number of QP done scheduling due to e2e credits (other peer credits)" id="47" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_QP_DONE_DUE_TO_E2E_CREDITS"></counter>
					<counter name="Packets sent by SXW to SXP" uri="Mlx5.DeviceDiagnosticCounters.Packets_sent_by_SXW_to_SXP" description="Number of packets that were authorized to send by SXW (to SXP)" id="48" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_PACKET_SEND_SXW2SXP_GO_VLD"></counter>
					<counter name="Steering hit" uri="Mlx5.DeviceDiagnosticCounters.Steering_hit" description="Number of steering lookups that were hit" id="49" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_PERF_COUNT_STEERING_HIT"></counter>
					<counter name="Steering miss" uri="Mlx5.DeviceDiagnosticCounters.Steering_miss" description="Number of steering lookups that were miss" id="50" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_PERF_COUNT_STEERING_MISS"></counter>
					<counter name="Steering processing time" uri="Mlx5.DeviceDiagnosticCounters.Steering_processing_time" description="Number of clocks that steering pipe worked" id="51" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXW_PERF_COUNT_STEERING_RSE_0"></counter>
					<counter name="No send credits for scheduling time" uri="Mlx5.DeviceDiagnosticCounters.No_send_credits_for_scheduling_time" description="The number of clocks that were no credits for scheduling (Tx)" id="52" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXD_NO_SCHED_CREDITS"></counter>
					<counter name="No slow path send credits for scheduling time" uri="Mlx5.DeviceDiagnosticCounters.No_slow_path_send_credits_for_scheduling_time" description="The number of clocks that were no credits for scheduling (Tx) for slow path" id="53" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_SXD_NO_SLOW_PATH_SCHED_CREDITS"></counter>
					<counter name="TPT indirect memory key access" uri="Mlx5.DeviceDiagnosticCounters.TPT_indirect_memory_key_access" description="The number of indirect mkey accesses" id="54" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="DeviceDiagnosticCounterStruct" field="u64_TPT_INDIRECT_MEM_KEY"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 PCI Device Diagnostics" symbol="PciDeviceDiagnosticCounters" guid="{3967c534-b821-49e1-af1b-0d6055496b29}" uri="Mlx5.PciDeviceDiagnosticCounters" description="This set contains PCI device diagnostic counters" instances="multipleAggregate">
					<structs>
						<struct name="PciDeviceDiagnosticCounterStruct" type="PciDeviceDiagCounters"></struct>
					</structs>
					<counter name="PCI back-pressure cycles" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Back_Pressure_Cycles" description="The number of clocks where BP from PCI was received while trying to send packet to the host" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PXD_READ_BP"></counter>
					<counter name="PCI back-pressure cycles/Sec" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Back_Pressure_Cycles_Sec" description="The rate of clocks where BP from PCI was received while trying to send packet to the host" id="1" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PXD_READ_BP_SEC"></counter>
					<counter name="PCI write back-pressure cycles" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Write_Back_Pressure_Cycles" description="The number of clocks where there was lack of posted outbound credits from PCI while trying to send packet to the host" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_WRITE_BP"></counter>
					<counter name="PCI write back-pressure cycles/Sec" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Write_Back_Pressure_Cycles_Sec" description="The rate of clocks where there was lack of posted outbound credits from PCI while trying to send packet to the host" id="3" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_WRITE_BP_SEC"></counter>
					<counter name="PCI read back-pressure cycles" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Read_Back_Pressure_Cycles" description="The number of clocks where there was lack of non-posted outbound credits from PCI while trying to send packet to the host" id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_READ_BP"></counter>
					<counter name="PCI read back-pressure cycles/Sec" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Read_Back_Pressure_Cycles_Sec" description="The rate of clocks where there was lack of non-posted outbound credits from PCI while trying to send packet to the host" id="5" type="perf_counter_counter" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_READ_BP_SEC"></counter>
					<counter name="PCI read stuck no receive buffer" uri="Mlx5.PciDeviceDiagnosticCounters.PCI_Read_Stuck_No_Receive_Buffer" description="The number of clocks where there was lack in global byte credits for non-posted outbound from PCI while trying to send packet to the host" id="6" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_PCI_READ_STUCK_NO_COMPLETION_BUFFER"></counter>
					<counter name="Available PCI BW" uri="Mlx5.PciDeviceDiagnosticCounters.Available_PCI_BW" description="The number of 128 bytes that could have been received from the host" id="7" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_MAX_PCI_BW"></counter>
					<counter name="Used PCI BW" uri="Mlx5.PciDeviceDiagnosticCounters.Used_PCI_BW" description="The number of 128 bytes that have been received from the host" id="8" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u64_USED_PCI_BW"></counter>
					<counter name="RX PCI errors" uri="Mlx5.PciDeviceDiagnosticCounters.RX_PCI_errors" description="Counts physical layer PCIe signal integrity errors, the number of transitions to recovery due to Framing errors and CRC (dlp and tlp). If the counter is advancing, try to change the PCIe slot in use. Note: Only a continues increment of the counter value is considered an error." id="9" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u32RxPciErrors"></counter>
					<counter name="TX PCI errors" uri="Mlx5.PciDeviceDiagnosticCounters.TX_PCI_errors" description="Counts physical layer PCIe signal integrity errors, the number of transition to recovery initiated by the other side (moving to Recovery due to getting TS/EIEOS). If the counter is advancing, try to change the PCIe slot in use. Note: Only a continues increment of the counter value is considered an error." id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u32TxPciErrors"></counter>
					<counter name="TX PCI non-fatal errors" uri="Mlx5.PciDeviceDiagnosticCounters.TX_PCI_non_fatal_errors" description="Counts PCI transport layer Non-Fatal error msg sent. If the counter is advancing, try to change the PCIe slot in use." id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u32TxPciNonFatalErrors"></counter>
					<counter name="TX PCI fatal errors" uri="Mlx5.PciDeviceDiagnosticCounters.TX_PCI_fatal_errors" description="Counts PCIe transport layer fatal error msg sent. If the counter is advancing, try to change the PCIe slot in use." id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="PciDeviceDiagnosticCounterStruct" field="u32TxPciFatalErrors"></counter>
				</counterSet>
				<counterSet name="Mellanox WinOF-2 Rss Counters" symbol="RssDiagCounters" guid="{c79149a1-04b2-465a-9bee-78563cacee16}" uri="Mlx5.RssDiagCounters" description="Show counters for RSS traffic per CPU" instances="multipleAggregate">
					<structs>
						<struct name="RssDiagCountersBuf" type="RssDiagnosticCounters"></struct>
					</structs>
					<counter name="Rss IPv4 Only" uri="Mlx5.RssDiagCounters.Rss_IPv4_Only" description="Shows the number of received packets that have RSS hash calculated on IPv4 header only" id="0" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv4_Only"></counter>
					<counter name="Rss IPv4/Tcp" uri="Mlx5.RssDiagCounters.Rss_IPv4_Tcp" description="Shows the number of received packets that have RSS hash calculated on IPv4 and Tcp headers" id="1" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv4_Tcp"></counter>
					<counter name="Rss IPv4/Udp" uri="Mlx5.RssDiagCounters.Rss_IPv4_Udp" description="Shows the number of received packets that have RSS hash calculated on IPv4 and Udp headers" id="2" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv4_Udp"></counter>
					<counter name="Rss IPv6 Only" uri="Mlx5.RssDiagCounters.Rss_IPv6_Only" description="Shows the number of received packets that have RSS hash calculated on IPv6 header only" id="3" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv6_Only"></counter>
					<counter name="Rss IPv6/Tcp" uri="Mlx5.RssDiagCounters.Rss_IPv6_Tcp" description="Shows the number of received packets that have RSS hash calculated on IPv6 and Tcp headers" id="4" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv6_Tcp"></counter>
					<counter name="Rss IPv6/Udp" uri="Mlx5.RssDiagCounters.Rss_IPv6_Udp" description="Shows the number of received packets that have RSS hash calculated on IPv6 and Udp headers" id="5" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_IPv6_Udp"></counter>
					<counter name="Encapsulated Rss IPv4 Only" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv4_Only" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv4 header only" id="10" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv4_Only"></counter>
					<counter name="Encapsulated Rss IPv4/Tcp" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv4_Tcp" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv4 and Tcp headers" id="11" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv4_Tcp"></counter>
					<counter name="Encapsulated Rss IPv4/Udp" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv4_Udp" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv4 and Udp headers" id="12" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv4_Udp"></counter>
					<counter name="Encapsulated Rss IPv6 Only" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv6_Only" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv6 header only" id="13" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv6_Only"></counter>
					<counter name="Encapsulated Rss IPv6/Tcp" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv6_Tcp" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv6 and Tcp headers" id="14" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv6_Tcp"></counter>
					<counter name="Encapsulated Rss IPv6/Udp" uri="Mlx5.RssDiagCounters.Encap_Rss_IPv6_Udp" description="Shows the number of received encapsulated packets that have RSS hash calculated on IPv6 and Udp headers" id="15" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_IPv6_Udp"></counter>
					<counter name="NonRss IPv4 Only" uri="Mlx5.RssDiagCounters.NonRss_IPv4_Only" description="Shows the number of Ipv4only packets that have no RSS hash calculated by HW" id="20" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv4_Only"></counter>
					<counter name="NonRss IPv4/Tcp" uri="Mlx5.RssDiagCounters.NonRss_IPv4_Tcp" description="SShows the number of Ipv4Tcp packets that have no RSS hash calculated by HW" id="21" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv4_Tcp"></counter>
					<counter name="NonRss IPv4/Udp" uri="Mlx5.RssDiagCounters.NonRss_IPv4_Udp" description="Shows the number of Ipv4Udp packets that have no RSS hash calculated by HW" id="22" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv4_Udp"></counter>
					<counter name="NonRss IPv6 Only" uri="Mlx5.RssDiagCounters.NonRss_IPv6_Only" description="Shows the number of Ipv6Only packets that have no RSS hash calculated by HW" id="23" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv6_Only"></counter>
					<counter name="NonRss IPv6/Tcp" uri="Mlx5.RssDiagCounters.NonRss_IPv6_Tcp" description="Shows the number of Ipv6Tcp packets that have no RSS hash calculated by HW" id="24" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv6_Tcp"></counter>
					<counter name="NonRss IPv6/Udp" uri="Mlx5.RssDiagCounters.NonRss_IPv6_Udp" description="Shows the number of Ipv6Udp packets that have no RSS hash calculated by HW" id="25" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_IPv6_Udp"></counter>
					<counter name="Encapsulated NonRss IPv4 Only" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv4_Only" description="Shows the number of encapsulated Ipv4Only packets that have no RSS hash calculated by HW" id="30" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv4_Only"></counter>
					<counter name="Encapsulated NonRss IPv4/Tcp" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv4_Tcp" description="Shows the number of encapsulated Ipv4Tcp packets that have no RSS hash calculated by HW" id="31" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv4_Tcp"></counter>
					<counter name="Encapsulated NonRss IPv4/Udp" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv4_Udp" description="Shows the number of encapsulated Ipv4Udp packets that have no RSS hash calculated by HW" id="32" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv4_Udp"></counter>
					<counter name="Encapsulated NonRss IPv6 Only" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv6_Only" description="Shows the number of encapsulated Ipv6Only packets that have no RSS hash calculated by HW" id="33" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv6_Only"></counter>
					<counter name="Encapsulated NonRss IPv6/Tcp" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv6_Tcp" description="Shows the number of encapsulated Ipv6Tcp packets that have no RSS hash calculated by HW" id="34" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv6_Tcp"></counter>
					<counter name="Encapsulated NonRss IPv6/Udp" uri="Mlx5.RssDiagCounters.Encap_NonRss_IPv6_Udp" description="Shows the number of encapsulated Ipv6Udp packets that have no RSS hash calculated by HW" id="35" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_IPv6_Udp"></counter>
					<counter name="Rss Misc" uri="Mlx5.RssDiagCounters.Rss_Misc" description="Shows the number of received packets that have RSS hash calculated with unknown RSS hash type" id="40" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Misc"></counter>
					<counter name="Encapsulated Rss Misc" uri="Mlx5.RssDiagCounters.Encap_Rss_Misc" description="Shows the number of received encapsulated packets that have RSS hash calculated with unknown RSS hash type" id="41" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="Rss_Encap_Misc"></counter>
					<counter name="NonRss Misc" uri="Mlx5.RssDiagCounters.NonRss_Misc" description="Shows the number of packets that have no RSS hash calculated by HW without clear reason for that" id="42" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Misc"></counter>
					<counter name="Encapsulated NonRss Misc" uri="Mlx5.RssDiagCounters.Encap_NonRss_Misc" description="Shows the number of encapsulated packets that have no RSS hash calculated by HW without clear reason for that" id="43" type="perf_counter_large_rawcount" detailLevel="standard" aggregate="sum" struct="RssDiagCountersBuf" field="NonRss_Encap_Misc"></counter>
				</counterSet>
			</provider>
		</counters>
	</instrumentation>
</instrumentationManifest>
