# Introduction

This GitHub repository dives into fundamental concepts I believe are important for understanding debugging and troubleshooting complex issues on Windows. I'm not referring to issues like AD Replication or printer malfunctions but problems that are related to things such as crash dumps, hangs, performance issues, and memory leaks.

I initially created this as a personal reference when I was (and still) learning more about this topic. Over time, I decided to consolidate these resources and make them publicly available, hoping they could assist others who are keen to explore this topic and learn more about it. The audience of this content should be people that are looking to get started, and might come from an IT Pro background. This GitHub repository may be pre-requisite for future content.

The content is organized into various sections, each designed to be as hands-on as possible. I believe that practice is the key to mastery. Therefore, each section goes beyond just the theory aspects, emphasizing practical examples using tools like Visual Studio, Process Explorer, and WinDbg. Click on **'Debugging 101'** to get started.

The following topics will be covered:

**Debugging 101**

```
- Section 0: How to get started?
- Section 1: Introduction to MEX Extension
- Section 2: Enable Postmortem Debugging
- Section 3: Access Violation
- Section 4: Setup and Create First Driver
- Section 5: Code Defect
- Section 6: Handles
- Section 7: Debug Diag
- Section 8: Introduction to Windows Performance Toolkit
- Section 9: Triaging a Crash Dump
```

**Coding Fundamentals**

C Code Language:

```
- Section 1: Variables
- Section 2: Operators
- Section 3: Control Flow
- Section 4: Pointers, Arrays and Strings
- Section 5: Structures
- Section 6: Input & Output
- Section 7: Command Line Arguments
- Section 8: Memory Allocation
- Section 9: Linked List
```

C++ Code Language:

```
- Section 1: Classes
- Section 2: Initializer Lists
- Section 3: Function Overloading and Templates
- Section 4: Copy and Move Constructors
- Section 5: Inheritance
- Section 6: Smart Pointers
- Section 7: Standard Libraries
```

**Windows API**

```
- Section 1: Threads
- Section 2: Critical Section
- Section 3: Conditional Variables
- Section 4: Interlocked Functions
- Section 5: Wait Functions and Signaling
- Section 6: Event Signaling
- Section 7: Mutex
- Section 8: Semaphore
- Section 9: Slim Reader/Writer Locks
```

**Kernel Forensics**

```
- Section 1: Kernel Pool Memory
- Section 2: ERESOURCE
- Section 3: KMUTEX
- Section 4: Fast Mutex
- Section 5: Interrupt Request Levels (IRQL)
- Section 6: Guarded Mutex
- Section 7: Event Signaling
- Section 8: Semaphore
- Section 9: Pushlock
- Section 10: Spinlock
- Section 11: Kernel Callbacks
```
